<?php

include 'db.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>swipe Page Transition</title>
    <!-- <link rel="stylesheet" href="assests/css/bootstrap.min.css"> -->
    <link rel="stylesheet" href="assests/css/style.css">

    <!-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"> -->

      <!-- Bootstrap link -->
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
      <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
      <link rel="stylesheet" href="assests/css/icon-font.min.css">
  
      <!-- Vertical carousel slick theme -->
      <link rel="stylesheet" href="https://kenwheeler.github.io/slick/slick/slick.css">
      <link rel="stylesheet" href="https://kenwheeler.github.io/slick/slick/slick-theme.css">

      <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    <style>
        /* (Use the same CSS styles as provided in the React version) */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            user-select: none;
        }

        body {
            background-color: transparent;
        }

        #container {
            overflow-y: scroll;
            overflow-x: hidden;
        }
        
        #page0 {
            background: transparent;
        }

        #page1 {
            background-image: linear-gradient(to right, #670185 0%, #430053 100%);
        }

        #page2 {
            background-image: linear-gradient(to right, #ff2c2c 0%, #b50031 100%);
        }

        #root {
            display: flex;
            justify-content: center;
        }

        svg {
            position: fixed;
            height: 100%;
            z-index: 1001;
        }

        button {
            /* position: absolute; */
            /* top: -627px; */
            /* left: 70px; */
            width: 40px;
            height: 40px;
            font-size: 25px;
            font-weight: 700;
            border-radius: 50%;
            font-family: "Oswald", sans-serif;
            background: transparent;
            color: #FCD863;
            /* border: 1px solid rgba(255, 255, 255, 0.4); */
            border: none;
            /* top: 10px; */
            /* left: 80px; */
        }


        button:focus {
            outline: 0;
        }

        img {
            width: 43vh;
            /* margin-left: 15px; */
        }

        .header {
            display: flex;
            justify-content: space-between;
            color: rgb(255, 255, 255);
            font-family: "Roboto", sans-serif;
            font-size: 19px;
            padding: 0px 31px;
        }

        #header0 {
            color: #000;
        }

        #header1 {
            color: rgb(255, 255, 255);
        }

        #header2 {
            color: #fff;
        }

        .skip {
            font-weight: 400;
        }

        #content {
            display: flex;
            flex-direction: column;
            padding: 0px 48px;
            height: 30vh;
            /* position: relative; */
        }

        .contentL1 {
            color: rgb(0, 0, 0);
            font-family: monospace;
            font-weight: 100;
            text-align: left;
            letter-spacing: -2px;
            line-height: 18px;
            opacity: 0.3;
        }

        .contentL2 {
            color: #000;
            font-family: "Oswald", sans-serif;
            margin-bottom: 8px;
            text-align: left;
        }

        .contentL3 {
            color: #000;
            font-family: "Roboto", sans-serif;
            text-align: left;
            font-size: 15px;
            font-weight: 100;
            word-spacing: 2px;
            letter-spacing: 1px;
            opacity: 0.5;
        }

        .text0 {
            color: #000;
        }

        .text1 {
            color: #fd5888;
        }

        .text2 {
            color: #fff;
        }

        .button0 {
            text-transform: uppercase;
            font-size: 25px;
            font-weight: 700;
            color: #FCD863;
            /* top: -627px; */
            /* left: 70px; */
            /* border: 1px solid rgba(0, 0, 0, 0.0); */
            background-color: transparent;
            border: none;
            z-index: 1001;
            position: fixed;
            transition: transform 0.3s ease-in;
            transform-origin: center;
        }

        .button.dragging {
            animation: dragAnimation 2s ease-in-out infinite;
        }

        @keyframes dragAnimation {
            0% {
                transform: translateX(0) translateY(0);
            }
            50% {
                transform: translateX(50%) translateY(0);
            }
            100% {
                transform: translateX(100%) translateY(0);
            }
        }

        .button1 {
            color: #fff;
            border: 1px solid rgba(255, 255, 255, 0.4);
           
        }

        .button2 {
            color: #fff;
            border: 1px solid rgba(255, 255, 255, 0.4);
        }

        @media only screen and (max-width: 500px) {
            #container {
                /* width: 100%; */
            }
        }

        .card-title {
            margin-bottom: 0;
        }

        p {
            margin-top: 0;
            margin-bottom: 0;
        }

        .row {
            margin-right: 0px;
            margin-left: 0px;
        }

        .card {
            border-radius: 15px;
        }

        .scrollbar-container {
            /* max-width: 100vh; */
            overflow-x: hidden !important;
            overflow-y: scroll;
            position: relative;
            overflow-x: hidden;
        }

        ::-webkit-scrollbar {
            width: 4px !important;
            /* background: beige; */
            /* background-color: transparent; */
            overflow-x: hidden !important;
        }

        ::-webkit-scrollbar-thumb {
            background: #000;
            overflow-x: hidden !important;
        }

        ::-webkit-scrollbar-track {
            /* width: 10px; */
            /* background-color: beige; */
        }
        
        /* Scrollbar */
        .scrollbar-container {
            --scrollbar-color-track: transparent;
            --scrollbar-color-thumb: #0B132B;
            overflow-x: hidden !important;
        }

       
        @supports (scrollbar-width: auto) {
            .scrollbar-container {
                scrollbar-color: var(--scrollbar-color-thumb) var(--scrollbar-color-track);
                overflow-x: hidden !important;
            }

            .warning {
                display: none;
            }
        }

        .scrollbar-container {
            /* height: 100vh; */
            position: relative;
            container-type: inline-size;
        }

        .increase-num {
            z-index: 10;
        }
        .num-anim {
            color: lightgray;
            /* animation: zoom-in-zoom-out 1s ease-out; */
            display: none;
            z-index: 10; 
        }

        .num-anim.animate {
            animation: zoom-in-zoom-out 0.5s ease-out;
            z-index: 1;
        }

        .swipe-indicator {
            position: fixed;
            top: 50%;
            left: -40px;
            transform: translateY(-50%);
            /* background-color: #000; */
            color: #000;
            padding-left: 25px;
            cursor: pointer;
            z-index: 1001;
            display: flex;
            align-items: center;
            /* animation: swipeAnimation 2s ease-in-out infinite;  */
            transition: transform 0.3s ease-in; 
            border-top: 0px;
            border-bottom: 0px;
            border-left: 0px;
            border-right: 1px;
            border-style: solid;
            border-color: lightgray;
            padding-top: 50px;
            padding-bottom: 50px;
            box-shadow: 1px 5px 5px 1px #cfd1d5c7;
            /* border-radius: 0 50px 50px 0; */
            border-radius: 0 50% 50% 0;
            width: 10px;
        }

        #site-wrapper {
            position: fixed;
            top: 40%;
            left: -80px;
            transform: translate(-50%);
            cursor: pointer;
            transition: transform 0.3s ease-in; 
            /* width: 10%; */
            /* max-width: 100px; */
        }


        .arrow-icon {
            margin-left: auto; 
            transition: transform 0.3s ease;
        }

        @keyframes swipeAnimation {
            0%, 100% {
                transform: translateY(-50%) translateX(0);
            }
            50% {
                transform: translateY(-50%) translateX(10px);
            }
        }

        #hamburger-container-curve {
            fill: transparent;
            stroke: lightgray;
            filter: drop-shadow(0 4px 4px rgba(0, 0, 0, 0.25));
        }
        /* @keyframes swipeAnimation {
            0% {
                transform: translateY(-50%) translateX(0);
            }
            50% {
                transform: translateY(-50%) translateX(5px);
            }
            100% {
                transform: translateY(-50%) translateX(0);
            }
        } */

        .no-scroll {
                overflow: hidden;
        width: 0px; 
            }
        @media (max-width: 480px) {

            #container {
                overflow: hidden;
            }
            .content {
                overflow-y: auto; 
                max-height: 86vh;
                top: 20px;
            }
            .content::-webkit-scrollbar {

            }

            /* Track */
            body::-webkit-scrollbar-track,
            body::-webkit-scrollbar-track {
                /* background: white;  */
            }

            /* Handle */
            body::-webkit-scrollbar-thumb,  
            body::-webkit-scrollbar-thumb {
                /* background: #0B132B;  */
            }

            /* Handle on hover */
            body::-webkit-scrollbar-thumb:hover,
            body::-webkit-scrollbar-thumb:hover {
                /* background: #000000;  */
            }
        }
         
        #container {
            display: none;
        }
       
        @media (max-width: 480px) {
            #container {
            display: block;
        }
       
        }

        .amountbtn {
            width: fit-content;
            /* top: 10px; */
            /* left: 290px; */
            font-weight: 700;
            background-color: #FCD863;
            border-radius: 20px;
            font-size: 17px;
        }

        @media (max-width: 480px) {
            .amountbtn {
                /* left: 350px; */
            }
            .logo {
                /* top: 10px; */
            }
            button {
                /* top: 22px; */
                /* left: 80px; */
            }
        }

       
        @media (max-width: 475px) {
            button {
                /* top: 20px; */
            }
        }

        @media (max-width: 470px) {
            button {
                /* top: 10px; */
            }
        }

        /* @media (max-width: 470px) {
            button {
                top: 22px;
            }
        } */
        
        @media (max-width: 450px) {
            .amountbtn {
                font-size: 16px;
                /* left: 325px; */
            }
        }

        @media (max-width: 450px) {
            .amountbtn {
                font-size: 16px;
                /* left: 325px; */
            }
        }
    
        @media (max-width: 420px) {
            .amountbtn {
                /* left: 290px; */
                font-size: 17px;
                /* top: 20px; */
            }

            button {
                /* top: 22px; */
                /* left: 80px; */
            }
        }

        

        @media (max-width: 400px) {
            button {
                /* top: 22px; */
                /* left: 80px; */
            }
            .amountbtn {
                /* top: 20px; */
                /* left: 270px; */
                font-size: 17px;
            }
        }

        @media (max-width: 380px) {
            .amountbtn {
                /* left: 250px; */
            }
        }

        @media (max-width: 350px) {
            .amountbtn {
                /* left: 240px; */
            }
        }

        /* Drag Top Bar */

        .side-menu a {
        display: block;
        text-decoration: none;
        color: #fff;
        }

        .icon-tap {
        position: relative;
        }

        .side-menu {
            /* position: fixed; 
            top: 0; 
            left: 0; 
            width: 100%; 
            height: 15%;
            background: #ccc;
            overflow: hidden; 
            transition: top 0.3s ease; 
            z-index: 1000;  */
        }
        /* #container {
  position: relative;
  height: 100vh;
}

#current-page {
  height: 100vh;
  background: #f0f0f0;
} */
    body.hidden-scroll {
            overflow: hidden;
        }
        #side-menu {
            position: relative; /* Use fixed positioning for proper visibility */
            top: -100%; /* Initially hidden off-screen */
            left: 0;
            width: 100%;
            background: #fff;
            z-index: 1000;
            transition: top 0.5s ease-in-out;
        }

        .icon-drag {
          font-size: 45px;
        }

        .container1 {
          width: 100%;
          margin: 10px auto;
        }
        .slider-vertical .slick-prev:before, .slider-vertical .slick-next:before {
          display: none;
        }
        .slider-vertical .slick-prev, .slider-vertical .slick-next {
            width: 0;
            height: 0;
            border-style: solid;
            margin: 10px;
            display: inline-block;
            left: 0;
            right: 0;
            margin: auto;
            z-index: 10;
            cursor: pointer;
        }
        .slider-vertical .slick-prev {
            border-width: 0 14px 14px 14px;
            border-color: #000000 transparent;
            top: -30px;
        }
        .slider-vertical .slick-next {
            border-width: 14px 14px 0px 14px;
            border-color: #000000 transparent;
            bottom: -30px;
            top: auto;
        }	
        .slider-vertical .slick-prev.slick-disabled, .slider-vertical .slick-next.slick-disabled {
          opacity: 0.1;
          cursor: default;
        }
        .slider-vertical div {
          text-align: center;
          font-size: 50px;
          color: #000;
        }

        .slider-vertical .slick-next {
          bottom: -20px;
        }

        .slider-vertical .slick-prev {
          top: -10px;
        }
        

        /* Light box */
        .lightbox {
          display: flex;
          justify-content: center;
          align-items: center;
          position: fixed;
          top: 0;
          left: 0;
          width: 100%;
          height: 100%;
          background: rgba(0, 0, 0, 0.7);
          z-index: 999;
      }

      .image-container {
          width: 600px;
          height: 408px;
          position: relative;
          text-align: center;
          display: flex;
          flex-direction: column;
          justify-content: center;
          align-items: center;
          border-radius: 5px;
      }

      @media (max-width: 580px) {
          .image-container {
          width: 400px;
          height: 280px;
      }
      }
      .img {
          max-width: 100%;
      }

      label {
          padding: 20px;
          font-size: 25px;
          font-weight: 600;
      }

      label:hover {
          background-color: #f1f1f1;
      }

      .custom-radio {
          width: 25px; 
          height: 25px; 
      }

      .text-end {
        text-align: right; 
    }

    .lightbox, .side-menu {
        display: none;
    }

    .mobile-text {
        display: block;
    }

    .disabled {
        pointer-events: none; 
        opacity: 0.7;
    }

    .side-menu.visible {
        top: 0; 
    }

    #side-menu {
        /* display: none; */
    }

    @media (max-width: 480px) {
        #side-menu {
            /* display: block; */
            background-color: #ccc;
        }

        .lightbox {
            display: flex;
        }

        .mobile-text {
            display: none;
        }
    }
    html {
    scroll-behavior: smooth;
}




/* TOP CARD */
.message {
    background-color: #ccc;
color:#FFF;
position: fixed;
top: -250px;
left: 0;
width: 100%;
height: 15%;
padding: 20px;
transition:  top 0.5s ease-in-out, opacity 0.5s ease-in-out;
        transition: top 1s cubic-bezier(0.17, 0.04, 0.03, 0.94);
        overflow: hidden;
        box-sizing: border-box;
        box-shadow: 0px 7px 5px rgba(0, 0, 0, 0.25);
  
}

#toggle {
  position:absolute;
  appearance:none;
  cursor:pointer;
  left:-100%;
  top:-100%;
}

#toggle + label {
  position:absolute;
  cursor:pointer;
  padding:10px;
  background: #26ae90;
width: 100px;
border-radius: 3px;
padding: 8px 10px;
color: #FFF;
line-height:20px;
font-size:12px;
text-align:center;
-webkit-font-smoothing: antialiased;
cursor: pointer;
  margin:20px 50px;
  transition:all 500ms ease;
}
#toggle + label:after {
  content:"Open" 
}

#toggle:checked ~ .message {
  top: 0;
}

#toggle:checked ~ .container {
  margin-top: 140px;
}

#toggle:checked + label {
  background:#dd6149;
}

#toggle:checked + label:after {
  content:"Close";
}

.container.disabled {
    pointer-events: none;
    opacity: 0.7; 
}

.container {
  transition: margin-top 0.5s ease-in-out;
  --bs-gutter-x: 0rem;
}

.btn-dashboard {
    border: 2px solid #FCD863;
    color: #FCD863;
    border-radius: 10px;
}

.btn-dashboard:hover {
    border: 2px solid #0B132B;
    color: #0B132B;  
}

.btn-dashboard i {
    width: 30px;
    height: 30px;
    font-size: 30px;
}

.btn-dashboard-layour {
    text-align: right;
    overflow: hidden !important;
}


/* Explore Button */
/* Basic Styles */

@media (max-width: 480px) {
    .col-md-6 {
        width: 50%;
    }
}


/* Button toggle swiper */
.slider-container {
        width: 80%;
        display: flex;
        justify-content: center;
        align-items: center;
        margin: 20px;
    }

    .styled-slider {
        width: 80%;
        appearance: none;
        background: #2e0052; /* Dark purple track background */
        height: 1rem;
        border-radius: 20px;
        position: relative;
    }

    /* Track styles */
    .styled-slider::-webkit-slider-runnable-track {
        height: 2.5rem;
        border-radius: 20px;
        background-color: #2e0052;
    }

    .styled-slider::-moz-range-track {
        height: 2.5rem;
        border-radius: 20px;
        background-color: #2e0052;
    }

    .styled-slider:focus {
        outline: none;
    }

    /* Thumb styles */
        .pullee::-webkit-slider-thumb {
    appearance: none;
    width: 2.5rem;
    height: 2.5rem;
    border-radius: 50%;
    background-color: #FCD863;
    cursor: pointer;
    background-size: 50%;
    background-position: center;
    background-repeat: no-repeat;
    transition: box-shadow 0.4s ease-in-out; 
}

.pullee.pulse-active::-webkit-slider-thumb {
    box-shadow: 0 0 0 10px rgb(46, 0, 82, 0.6),
                0 0 0 15px rgba(46, 0, 82, 0.4),
                0 0 0 20px rgba(50, 4, 86, 0.2);
}

.pullee::-moz-range-thumb {
    width: 2.5rem;
    height: 2.5rem;
    border-radius: 50%;
    background-color: #a0ff00;
    cursor: pointer;
    transition: box-shadow 0.4s ease-in-out;
}

.pullee.pulse-active::-moz-range-thumb {
    box-shadow: 0 0 0 10px rgba(217, 108, 240, 0.6),
                0 0 0 15px rgba(219, 143, 235, 0.4),
                0 0 0 20px rgba(226, 195, 232, 0.2); 
}


    .slider-track-content {
        position: absolute;
        left: 0;
        right: 0;
        text-align: center;
        pointer-events: none; 
        z-index: 1;
    }
    
    .slider-text {
        font-size: 1.2rem;
        color: white;
        font-weight: bold;
        opacity: 0.2;
    }
    </style>   

</head>
<body class="hidden-scroll">

    <h1 class="mobile-text text-center">Change to Mobile VIew</h1>
     <!-- Lightbox -->
    <div id="lightbox" class="lightbox" style="display: none;">
        <div class="image-container">
            <div class="card" style="padding: 20px; height: fit-content; width: 100%;">
                <div class="row d-flex align-items-center">
                    <div class="col-md-11 col-11"></div>
                    <div class="col-md-1 col-1 text-end justify-content-end">
                        <a class="btn btn-default text-end" id="closeLightbox" style="right: 10%; color: #000; text-decoration: none;"><i class="fa fa-x" style="font-weight: 900;"></i></a>
                    </div>
                </div>
                
                <?php 
                $category = "SELECT * FROM category WHERE delete_status=0";
                $catresult = mysqli_query($connection, $category);

                if ($catresult && mysqli_num_rows($catresult) > 0) {
                    // Loop through the categories
                    while ($row = mysqli_fetch_assoc($catresult)) {
            ?>
                    <label for="category_<?php echo $row['id']; ?>">
                        <?php echo htmlspecialchars($row['category']); ?>&nbsp;&nbsp;
                        <span>
                            <input type="radio" name="category" id="category_<?php echo $row['id']; ?>" class="custom-radio category-radio" data-category-id="<?php echo $row['id']; ?>">
                        </span>
                    </label>
            <?php
                    }
                }
            ?>
            </div>
        </div>
    </div>
    

        <input type="checkbox" name="toggle" id="toggle" style="display: none;"/>
        <label for="toggle" style="display: none;"></label>
    <!-- <div id='root'> -->
        <div id="container" class="container">
            <div class="page-head" id="page-head">
                <div class="row">
                    <div class="col-md-6">
                        <div class="logo">hapi <span class="taplogo">tap</span></div>
                    </div>
                    <div class="col-md-6 text-end">
                    <button  class="btn btn-default amountbtn" style=""><i class="fa fa-calculator"></i>  ₹ <span id="totalAmountDisplay">0</span></button>
                    </div>
                </div>
            </div>
            <!-- <button id="tapLogoButton${index}" class="" style="opacity: 1; transform: translateX(0px); transition: transform 0.3s ease-in;"></button> -->
          
            <div class="row content"  id="productContainer">
             

             <?php
             $categoryId = isset($_GET['categoryId']) ? $_GET['categoryId'] : null;
             
             // Validate and sanitize category ID
             $categoryId = $categoryId ? mysqli_real_escape_string($connection, $categoryId) : null;
             
             // Base query to fetch products
             $query = "
                 SELECT 
                     p.id AS product_id, 
                     p.productname, 
                     p.productimage, 
                     p.price, 
                     p.productdesc,
                     p.colour";
             
             // Check if categoryId is provided
             if ($categoryId) {
                 // Join with catagorydata when categoryId is present
                 $query .= ", c.position 
                     FROM 
                         product p 
                     INNER JOIN 
                         catagorydata c 
                     ON 
                         p.id = c.productid 
                     WHERE 
                         p.delete_status = 0 
                         AND c.delete_status = 0 
                         AND c.mode = 1 
                         AND c.categoryid = '$categoryId'
                     ORDER BY 
                         c.position ASC";
             } else {
                 // Fetch all products when categoryId is not provided
                 $query .= " 
                     FROM 
                         product p 
                     WHERE 
                         p.delete_status = 0";
             }
             
             $result = mysqli_query($connection, $query);
             
             // Check if the query execution is successful
             if ($result && mysqli_num_rows($result) > 0) {
                 while ($product = mysqli_fetch_assoc($result)) {
                     ?>
                 <div class="col-6">
                        <div class="card"  data-productid="<?php echo $product['product_id']; ?>" data-productname="<?php echo $product['productname']; ?>" data-amount="<?php echo $product['price']; ?>" data-categoryid="<?php echo $categoryId;?>">
                        <div class="card-content text-center">
                                         <div class="row">
                                             <div class="col-6 text-start">
                                                 <p class="num-anim">+1</p>
                                             </div>
                                             <div class="col-6 text-end">
                                                 <p class="increase-num">0</p>
                                             </div>
                                         </div><p style="display:none;"><?php echo $product['product_id']; ?></p>
                                         <img src="<?php echo $product['productimage'] ;?>" alt="<?php echo $product['productname'];?>" title="<?php echo $product['productdesc'];?>">
                                     </div>
                                     <div class="card-title text-center" style= "background-color: <?php echo $product['colour'];?>;">
                                         <p><?php echo $product['productname']; ?></p>
                                         <p style="display:none;"> <?php echo $product['price'];?></p>
                                     </div>
                                 </div>
                             </div><?php
                 }
             } else {
                 echo "<p>No products available.</p>";
             }
             
             
             ?>
             
                             <!-- <div class="col-12 btn-dashboard-layour">
                                 <input type="range" value="0" class="pullee" />
                             </div> -->
                             <div class="row align-items-center justify-content-center">
                                 <div class="slider-container" style="text-align: center;">
                                     <input type="range" value="0" class="styled-slider pullee" min="0" max="150" style="text-align: center;" />
                                     <div class="slider-track-content">
                                         <span class="slider-text">Dashboard</span>
                                     </div>
                                 </div>
                             </div>
                          
                             <br><br><br><br><br><br><br>
                             
                         </div>
                     </div>
                    
                             
                 <!-- </div> -->
                   <!-- Menu Drag -->
                 <div class="message" id="">
                     <div class="row" style="padding: 20px;">
                         <div class="col-md-3 col-3 text-left">
                             <img src="assests/images/refresh.png" class="undo-image" alt="" style="width: 80px; margin-left: -20px;">
                         </div>
                         <div class="col-md-6 col-6">
                             <div class="container1">
                                 <div class="slider-vertical">
                                     <div><h3>Morning</h3></div>
                                     <div><h3>Afternoon</h3></div>
                                     <div><h3>Evening</h3></div>
                                     <div><h3>Night</h3></div>
                                 </div>  
                             </div>
                         </div>
                          <div class="col-md-3 col-3 text-end">
                             <img src="assests/images/security.png" alt="" style="width: 65px;">
                         </div>
                     </div>
                 </div>
             
                 <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
                
                     
                 <script> 
                    //  $(document).ready(function () {
                    //      $('.category-radio').change(function () {
                    //          const categoryId = $(this).data('category-id');
             
                    //          $.ajax({
                    //              url: '', 
                    //              type: 'GET',
                    //              data: { categoryId: categoryId },
                    //              success: function (response) {
                    //                  $('#productContainer').html($(response).find('#productContainer').html());
                    //              },
                    //              error: function () {
                    //                  alert('Error loading products. Please try again.');
                    //              }
                    //          });
                    //      });
                    //  });
                 </script>

<!-- Card number count --> 
<script>
$(document).ready(function () {
    const productContainer = $('#productContainer'); // Parent container for dynamic elements
    let globalTotal = 0; // Initialize global total for all products

  
 // Delegate click event to the parent container
productContainer.on('click', '.card', function () {
    const card = $(this);

    // Retrieve the existing count from the session data or local data
    let count = card.data('count') || 0;  // Get the current count, default to 0 if not available

    // Increment the cumulative tap count
    count += 1;
    card.data('count', count); // Update data with the new count

    // Increment the temporary tap count for animation (this can stay the same)
    let count1 = card.data('count1') || 0;
    count1 += 1;
    card.data('count1', count1);

    // Update `numAnim` to show `+count1` and animate it
    const numAnim = card.find('.num-anim');
    numAnim.text(`+${count1}`).css('display', 'block').removeClass('animate');
    void numAnim.get(0).offsetWidth; // Trigger reflow to restart animation
    numAnim.addClass('animate');

    // Update `increaseNum` to reflect the cumulative count
    const increaseNum = card.find('.increase-num');
    increaseNum.text(count);  // Display updated count

    // Calculate and display the total amount for this product
    const amount = parseFloat(card.data('amount')) || 0; // Use 0 if amount is not numeric
    const totalAmount = amount * count;

    // Update the global total amount and display it
    updateGlobalTotal();

    // Call storeInSession to save updated data in the session
    const productId = card.data('productid');
    const productName = card.data('productname');
    const categoryId = $('.category-radio:checked').data('category-id'); // Current category ID
    storeInSession(productId, productName, totalAmount, count, categoryId);

    // Send AJAX request with updated count and amount
    sendTapData(productId, productName, amount, count);

    // Hide `numAnim`, reset `count1`, and reset `totalAmountDisplay` after a delay
    if (card.data('resetTimeout')) {
        clearTimeout(card.data('resetTimeout'));
    }
    card.data('resetTimeout', setTimeout(() => {
        numAnim.css('display', 'none'); // Hide animated display
        card.data('count1', 0); // Reset `count1` only, not `count`

        // Recalculate and reset total display after count1 resets
        updateGlobalTotal(); // Update display based on cumulative counts
    }, 500));
});

    // Function to update the global total amount based on all card counts
    function updateGlobalTotal() {
        // Reset global total and recalculate based on each card's cumulative count and amount
        globalTotal = 0;
        productContainer.find('.card').each(function () {
            const amount = parseFloat($(this).data('amount')) || 0; // Use 0 if amount is not numeric
            const count = $(this).data('count') || 0;
            globalTotal += amount * count;
        });
        // Update the display with the global total
        $('#totalAmountDisplay').text(globalTotal.toFixed(2)); // Display to 2 decimal places if needed
    }

    // AJAX function to store data in session
    function storeInSession(productId, productName, productTotal, taps, categoryId) {
        $.ajax({
            url: 'storeInSession.php', // Backend script to store in session
            type: 'POST',
            data: {
                productid: productId,
                productname: productName,
                producttotal: productTotal,
                taps: taps,
                categoryid: categoryId
            },
            success: function (response) {
                console.log('Data stored in session:', response); // For debugging
            },
            error: function () {
                alert('Error storing data in session.');
            }
        });
    }

    // AJAX function to send tap data
    function sendTapData(productId, productName, amount, taps) {
        $.ajax({
            url: 'recordTap.php', // PHP backend script
            type: 'POST',
            data: {
                productid: productId,
                productname: productName,
                amount: amount,
                taps: taps
            },
            success: function (response) {
                console.log(response); // Debugging response
            },
            error: function () {
                alert('Error sending tap data.');
            }
        });
    }

    // Handle category radio button change
    $('.category-radio').change(function () {
        const categoryId = $(this).data('category-id');
        console.log('Sending Category ID:', categoryId);

        $.ajax({
            url: 'getSessionData.php', // Get session data based on category
            type: 'GET',
            data: { categoryid: categoryId },
            success: function (response) {
                console.log('Response from Server:', response);
                const res = JSON.parse(response);
                if (res.status === 'success') {
                    displayCategoryData(res.data, res.categoryId);
                } else {
                    console.error('Error:', res.message);
                    resetCategoryDisplay();
                }
            },
            error: function () {
                alert('Error fetching session data.');
            }
        });
    });

   // Display category data based on session
function displayCategoryData(data, categoryId) {
    productContainer.find('.card').each(function () {
        const card = $(this);
        const productId = card.data('productid');

        if (data[productId]) {
            const productData = data[productId];
            const taps = productData.taps;

            // Update tap count and UI
            card.data('count', taps); // Store taps in data
            card.find('.increase-num').text(taps); // Display taps in the UI
        } else {
            // Reset tap count and UI if product is not in session data
            card.data('count', 0);
            card.find('.increase-num').text(0);
        }
    });

    updateGlobalTotal(); // Recalculate and update global total
}

// Reset category display
function resetCategoryDisplay() {
    productContainer.find('.card').each(function () {
        $(this).data('count', 0); // Reset all counts
        $(this).find('.increase-num').text(0); // Reset all UI elements
    });
    updateGlobalTotal(); // Update the global total after resetting
}

    // Undo reset category session data
    $('.undo-image').click(function () {
        const categoryId = $('.category-radio:checked').data('category-id');
        if (!categoryId) return;

        $.ajax({
            url: 'resetSession.php', // Reset session data for category
            type: 'POST',
            data: { categoryid: categoryId },
            success: function (response) {
                const res = JSON.parse(response);
                if (res.status === 'success') {
                    resetCategoryDisplay();
                } else {
                    alert(res.message);
                }
            },
            error: function () {
                alert('Error resetting session data.');
            }
        });
    });
});


</script>





<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-mousewheel/3.1.12/jquery.mousewheel.js"></script>
<script src="https://kenwheeler.github.io/slick/slick/slick.js"></script>
   

<!-- Vertical Carousel -->
<script>
  var slickCarousel = $('.slider-vertical');
  slickCarousel.slick({
      dots: true,
      infinite: false,
      speed: 300,
      slidesToShow: 1,
      slidesToScroll: 1,
      vertical: true,
      verticalSwiping: true,
      dots: false,
      centerPadding: '50px',
      arrows: true,
      prevArrow: '<button type="button" data-role="none" class="slick-prev" aria-label="Previous" tabindex="0" role="button"><i class="fa fa-angle-up"></i></button>',
      nextArrow: '<button type="button" data-role="none" class="slick-next" aria-label="Next" tabindex="0" role="button"><i class="fa fa-angle-down"></i></button>',
      responsive: [{
              breakpoint: 1024,
              settings: {
                  slidesToShow: 1,
                  slidesToScroll: 1,
                  infinite: true,
              }
          }, {
              breakpoint: 639,
              settings: {
                  slidesToShow: 1,
                  slidesToScroll: 1,
            vertical: false,
            verticalSwiping: false,
              }
          }
      ]
  });

  slickCarousel.mousewheel(function(e) {
  e.preventDefault();
      if (e.deltaY < 0) {
          $(this).slick('slickNext'); 
      }
      else {
          $(this).slick('slickPrev');
      }
  });
</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>


<!-- Drag up and down rly drag and tap -->
 <script>
    document.addEventListener('DOMContentLoaded', function () {
        const toggle = document.getElementById('toggle');
        const container = document.querySelector('.container');
        const message = document.querySelector('.message');
        const lightbox = document.getElementById('lightbox');
        let startY = 0;
        let isDragging = false;

        function handleTouchStart(e) {
            startY = e.touches[0].clientY;
            isDragging = true;
        }

        function handleTouchMove(e) {
            if (!isDragging) return;

            const currentY = e.touches[0].clientY;
            const distance = currentY - startY;

            
            if (distance > 0 && distance >= 400) {
                toggle.checked = true;
                container.classList.add('disabled'); 
                message.classList.add('show');
                message.classList.remove('hide');
                isDragging = false;  
            }

            if (distance < 0 && Math.abs(distance) >= 100) {
                message.classList.add('hide'); 
                message.classList.remove('show'); 
                setTimeout(() => {
                    toggle.checked = false;
                    container.classList.remove('disabled'); 
                }, 500); 
                isDragging = false;  
            }
        }

        function handleClickOutsideMessage(e) {
            if (!message.contains(e.target) && !container.contains(e.target) && !lightbox.contains(e.target)) {
                message.classList.add('hide');
                message.classList.remove('show');
                container.classList.remove('disabled');
                toggle.checked = false;
            }
        }

        container.addEventListener('touchstart', handleTouchStart);
        container.addEventListener('touchmove', handleTouchMove);
        message.addEventListener('touchstart', handleTouchStart);
        message.addEventListener('touchmove', handleTouchMove);

        document.addEventListener('click', handleClickOutsideMessage);

        container.addEventListener('touchend', function () {
            isDragging = false;
        });
        message.addEventListener('touchend', function () {
            isDragging = false;
        });

        document.querySelectorAll('.slider-vertical > div').forEach(function(item) {
            item.addEventListener('click', function() {
                lightbox.style.display = 'flex';
            });
        });

        document.getElementById('closeLightbox').addEventListener('click', function() {
            lightbox.style.display = 'none';
        });

        lightbox.addEventListener('click', function(e) {
            if (e.target === this) {
                this.style.display = 'none';
            }
        });
    });

    </script>
<!-- 
    <script>
        var inputRange = document.querySelector('.pullee'),
            maxValue = 150,
            speed = 12,
            currValue, rafID;

        inputRange.min = 0;
        inputRange.max = maxValue;

        function unlockStartHandler() {
            window.cancelAnimationFrame(rafID);
            currValue = +this.value;

            inputRange.classList.add('pulse-active');
        }

        function unlockEndHandler() {
            currValue = +this.value;

            if (currValue >= maxValue) {
                successHandler();
            } else {
                rafID = window.requestAnimationFrame(animateHandler);
            }

            inputRange.classList.remove('pulse-active');
        }

        function animateHandler() {
            inputRange.value = currValue;

            if (currValue > -1) {
                window.requestAnimationFrame(animateHandler);   
            }

            currValue = currValue - speed;
        }

        function successHandler() {
            window.location.href = "dashboard.php";
            const inputRange = document.querySelector('input[type="range"]');

            setTimeout(() => {
                inputRange.value = 0;
            }, 500); 
        }
        inputRange.addEventListener('mousedown', unlockStartHandler, false);
        inputRange.addEventListener('touchstart', unlockStartHandler, false);
        inputRange.addEventListener('mouseup', unlockEndHandler, false);
        inputRange.addEventListener('touchend', unlockEndHandler, false);


</script> -->

<script>
    function initializeSlider() {
        var inputRange = document.querySelector('.pullee'),
            maxValue = 150,
            speed = 12,
            currValue, rafID;

        if (!inputRange) return; // Prevent errors if .pullee doesn't exist

        inputRange.min = 0;
        inputRange.max = maxValue;

        function unlockStartHandler() {
            window.cancelAnimationFrame(rafID);
            currValue = +this.value;

            inputRange.classList.add('pulse-active');
        }

        function unlockEndHandler() {
            currValue = +this.value;

            if (currValue >= maxValue) {
                successHandler();
            } else {
                rafID = window.requestAnimationFrame(animateHandler);
            }

            inputRange.classList.remove('pulse-active');
        }

        function animateHandler() {
            inputRange.value = currValue;

            if (currValue > -1) {
                window.requestAnimationFrame(animateHandler);
            }

            currValue = currValue - speed;
        }

        function successHandler() {
            window.location.href = "dashboard.php";
            const inputRange = document.querySelector('input[type="range"]');

            setTimeout(() => {
                inputRange.value = 0;
            }, 500);
        }

        inputRange.addEventListener('mousedown', unlockStartHandler, false);
        inputRange.addEventListener('touchstart', unlockStartHandler, false);
        inputRange.addEventListener('mouseup', unlockEndHandler, false);
        inputRange.addEventListener('touchend', unlockEndHandler, false);
    }

    // Initialize slider on document ready
    document.addEventListener('DOMContentLoaded', initializeSlider);

    $(document).ready(function () {
        $('.category-radio').change(function () {
            // Get the selected category ID
            const categoryId = $(this).data('category-id');

            // Send AJAX request to fetch products for the selected category
            $.ajax({
                url: '', // Same file
                type: 'GET',
                data: { categoryId: categoryId },
                success: function (response) {
                    // Replace product container with new content
                    $('#productContainer').html($(response).find('#productContainer').html());

                    // Reinitialize the slider after content replacement
                    initializeSlider();
                },
                error: function () {
                    alert('Error loading products. Please try again.');
                }
            });
        });
    });
</script>

</body>
</html>
